#include "resource.h"
#include "glock3.hpp"
#include <stdlib.h> //For the atof function.
#include <stdio.h> //For the sprintf function.
#define MAX_CHARS 64

char numberstring[MAX_CHARS-1];
Real realeditvalue;
int inteditvalue;
int edit_id; /* This is important when you use Edit text box.
	You keep setting this to zero when you aren't editing
	text box. */
extern HWND main_hwnd;  //My main window, need for menu.
extern HWND hDlgParam;
extern GosperClock *glock; //The object I'm editing with this dialog.
static void showparams(HWND hDlg); /* This is static to this module because
	I'll have	functions with the same names in other dialog code modules. */

BOOL CALLBACK ParamDialogProc( HWND hDlg, UINT message, WPARAM wParam,
	LPARAM lParam )
{ /* Note that this looks just like WndProc.  A modeless dialog
	proc must return TRUE when it processes a message and return
	FALSE for all other messages */

	wParam = (int)LOWORD(wParam); //Need to do this for 32 bit.
	switch (message)
	{ //Normally these are the only messages you need process.
		case WM_INITDIALOG:
			CheckMenuItem( GetMenu(main_hwnd), IDM_PARAM,
				MF_BYCOMMAND | MF_CHECKED );
			edit_id = 0;
			showparams(hDlg);
			return TRUE;
		case WM_COMMAND:
			switch(wParam)
			{
				case PD_UPDATE:
					edit_id = 0;
					showparams(hDlg);
					break;
				case PD_TIMESTEP:
				case PD_HAND_COUNT:
				case PD_EDIT_HAND_ID:
				case PD_LENGTH:
				case PD_RATE:
				case PD_PHASE:
					edit_id = wParam; //That is, PD_TIMESTEP
					break;
				case IDOK: //This happens when you press Enter to end editing a box.
					GetWindowText(GetDlgItem(hDlg, edit_id),
						numberstring, MAX_CHARS);
					switch(edit_id)
					{
						case PD_TIMESTEP:
							realeditvalue = atof(numberstring);
							glock->SetDt(realeditvalue);
							break;
						case PD_HAND_COUNT:
							inteditvalue = atoi(numberstring);
							glock->SetHandCount(inteditvalue);
							break;
						case PD_EDIT_HAND_ID:
							inteditvalue = atoi(numberstring);
							glock->SetEditHandID(inteditvalue);
							break;
						case PD_LENGTH:
							realeditvalue = atof(numberstring);
							glock->SetEditHandLength(realeditvalue);
							glock->Reset();
							break;
						case PD_RATE:
							realeditvalue = atof(numberstring);
							glock->SetEditHandRate(realeditvalue);
							glock->Reset();
							break;
						case PD_PHASE:
							realeditvalue = atof(numberstring);
							glock->SetEditHandPhase(realeditvalue*PI);
							glock->Reset();
							break;
					}
					edit_id = 0;
					showparams(hDlg);
					break;
				default:
					break;
			}
			return TRUE;
		case WM_CLOSE: //This can be generated in various ways.
			DestroyWindow(hDlg);
			return TRUE;
		case WM_DESTROY: //
			CheckMenuItem( GetMenu(main_hwnd), IDM_PARAM,
				MF_BYCOMMAND | MF_UNCHECKED );
			hDlgParam = NULL;
			InvalidateRect( main_hwnd, NULL, TRUE );
			return TRUE;
		default:
			return FALSE;
	}
}

static void showparams(HWND hDlg)
{//Display current values based on your glock accessors.
	/* Because we are using an edit text box, care needs to be taken
		to prevent an  endless regress of showparams calling showparams which
		calls showparams, etc.  The SetWindowText call used to show the
		current value of the edit param timestep generates a call to WM_COMMAND
		with DW_TIMESTEP in wParam, and this sets edit_id to DW_TIMESTEP and
		sends a call to showparams() at the end of the WM_COMMAND.  We have
		to do two things about this (1) bail from showparams if edit_id is
		non-zero, and (2) restore edit_id to zero at the end of showparams.*/
	
	char szBuffer[64];
	
	if (edit_id)
		return; // This bails on regressive showparams calls from WM_COMMAND.
	sprintf (szBuffer, "%.3f", glock->dt());
	SetDlgItemText(hDlg, PD_TIMESTEP, (LPSTR)szBuffer);
		/* This sends WM_COMMAND, which gets processed right away, even before
		the next line of code.  And then WM_COMMAND calls showparams, and this is
		still BEFORE this first call to showparams gets a chance to finish and set
		edit_id to 0.  That's why we need the "if (edit_id) return;" at the
		beginning of showparams(), because we jump up to that line right here. */
	SetDlgItemInt(hDlg, PD_HAND_COUNT, glock->hand_count(), FALSE);
	SetDlgItemInt(hDlg, PD_EDIT_HAND_ID, glock->edit_hand_id(), FALSE);
	sprintf (szBuffer, "%.3f", glock->EditHandLength());
	SetDlgItemText(hDlg, PD_LENGTH, (LPSTR)szBuffer);
	sprintf (szBuffer, "%.3f", glock->EditHandRate());
	SetDlgItemText(hDlg, PD_RATE, (LPSTR)szBuffer);
	sprintf (szBuffer, "%.3f", glock->EditHandPhase()/PI);
	SetDlgItemText(hDlg, PD_PHASE, (LPSTR)szBuffer);
	edit_id = 0;  //This undoes the unwanted setting of edit_id by SetWindowText.
}


